/**************************\
|** WORMINATOR BULLET AI **|
\**************************/
void worminator_bullet_ai(int sprite_number)
{
char sprite_busted = FALSE;
int sprite_hit;

// Check the lifetime timer
if (sprites[sprite_number].timer > 0) sprites[sprite_number].timer--;
else sprite_busted = TRUE;

// Move the bullet right or left
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;

// Check to see if the bullet hit an enemy and take approprate action if so
sprite_hit = sprite_is_touching_sprite(sprite_number, 1);
if (sprite_hit >= 0) {
	sprite_busted = TRUE;
	sprites[sprite_hit].hit_points_left -= .25;
	}

// See if there are solid tiles in the way of the bullet
if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + (sprites[sprite_number].width / 2), sprites[sprite_number].y_position_in_pixels, 1);
else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + (sprites[sprite_number].width / 2), sprites[sprite_number].y_position_in_pixels, 1);

// If the bullet hit anything at all, then destroy it
if (sprite_busted == TRUE) {
	spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (sprites[sprite_number].x_acceleration / 2) * -1, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	destroy_sprite(sprite_number);
	return;
	}
}

/**************************\
|** WORMINATOR ROCKET AI **|
\**************************/
void worminator_rocket_ai(int sprite_number)
{
char sprite_busted = FALSE;
unsigned char spawn_loop;

// Move the rocket right or left, and up or down if the rocket is a split missle rocket
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;
sprites[sprite_number].y_position_in_pixels += sprites[sprite_number].y_acceleration;

// Check to see if the rocket hit an enemy and take appropriate action if so
if (sprite_is_touching_sprite(sprite_number, 1) >= 0) sprite_busted = TRUE;

// See if there are solid tiles in the way of the rocket and adjust the rocket's speed
if (sprites[sprite_number].direction == 0) {
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels, 1);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels, 1);
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 1);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 1);
	sprites[sprite_number].x_acceleration += .025;
	if (sprites[sprite_number].x_acceleration > 2) sprites[sprite_number].x_acceleration = 2;
	}

else {
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, 1);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, 1);
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 1);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 1);
	sprites[sprite_number].x_acceleration -= .025;
	if (sprites[sprite_number].x_acceleration < -2) sprites[sprite_number].x_acceleration = -2;
	}

// If the rocket hit anything at all, then destyoy it
if (sprite_busted == TRUE) {
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_RED_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	spawn_sprite(SMALL_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels - 3, NULL, NULL, NULL);
	spawn_sprite(SMALL_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels - 3, NULL, NULL, NULL);
	play_relative_sound(ROCKET_EXPLODE_SOUND, sprite_number);
	destroy_sprite(sprite_number);
	return;
	}
}

/**************************\
|** WORMINATOR MORTAR AI **|
\**************************/
void worminator_mortar_ai(int sprite_number)
{
char sprite_busted = FALSE;
unsigned char spawn_loop;
int tile_hit;

// Update lifespan timer
if (sprites[sprite_number].timer == 0) sprite_busted = TRUE;
else sprites[sprite_number].timer--;

// Rotate the mortar
if (sprites[sprite_number].rotate_factor == 255) sprites[sprite_number].rotate_factor = 0;
else sprites[sprite_number].rotate_factor++;

// Move the mortar
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;
sprites[sprite_number].y_position_in_pixels += sprites[sprite_number].y_acceleration;

// Check to see if the mortar hit an enemy and take appropriate action if so
if (sprite_is_touching_sprite(sprite_number, 1) >= 0) sprite_busted = TRUE;

// Check x direction
if (sprites[sprite_number].x_acceleration > 0 && check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height / 2, 2) == TRUE) sprites[sprite_number].x_acceleration = sprites[sprite_number].x_acceleration * -1;
else if (sprites[sprite_number].x_acceleration < 0 && check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height / 2, 2) == TRUE) sprites[sprite_number].x_acceleration = sprites[sprite_number].x_acceleration * -1;

// Check y direction
if (sprites[sprite_number].y_acceleration > 0 && check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width / 2, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2) == TRUE) sprites[sprite_number].y_acceleration = sprites[sprite_number].y_acceleration * -1;
else if (sprites[sprite_number].y_acceleration < 0 && check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width / 2, sprites[sprite_number].y_position_in_pixels, 2) == TRUE) sprites[sprite_number].y_acceleration = sprites[sprite_number].y_acceleration * -1;

// Apply gravity to the mortar
sprites[sprite_number].y_acceleration += .025;

// If the mortar hit anything damageable, then destyoy it
if (sprite_busted == TRUE) {
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 10, sprites[sprite_number].y_position_in_pixels - 10, NULL, NULL, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 10, sprites[sprite_number].y_position_in_pixels - 10, NULL, NULL, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 10, sprites[sprite_number].y_position_in_pixels - 10, NULL, NULL, NULL);
	play_relative_sound(ROCKET_EXPLODE_SOUND, sprite_number);
	destroy_sprite(sprite_number);
	return;
	}
}

/***********************************\
|** WORMINATOR BFG PLASMA BALL AI **|
\***********************************/
void worminator_bfg_plasma_ball_ai(int sprite_number)
{
char sprite_busted = FALSE;
unsigned char spawn_loop;

// Animate the plasma ball
if (sprites[sprite_number].timer == 0) {
	if (sprites[sprite_number].animation_state == 0) {
		sprites[sprite_number].frame++;
		sprites[sprite_number].timer = 8;
		if (sprites[sprite_number].frame == BFG_PLASMA_BALL_FLY_01 + 2) sprites[sprite_number].animation_state = 1;
		}
	else {
		sprites[sprite_number].frame--;
		sprites[sprite_number].timer = 8;
		if (sprites[sprite_number].frame == BFG_PLASMA_BALL_FLY_01) sprites[sprite_number].animation_state = 0;
		}
	}
else sprites[sprite_number].timer--;

// Move the plasma ball right or left
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;

// Check to see if the plasma ball hit an enemy and take appropriate action if so
if (sprite_is_touching_sprite(sprite_number, 1) >= 0) sprite_busted = TRUE;

// See if there are solid tiles in the way of the plasma ball and adjust it's speed

if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels, 1);
if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 1);
if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, 1);
if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 1);

if (sprites[sprite_number].direction == 0) {
	sprites[sprite_number].x_acceleration += .025;
	if (sprites[sprite_number].x_acceleration > 4) sprites[sprite_number].x_acceleration = 4;
	}

else {
	sprites[sprite_number].x_acceleration -= .025;
	if (sprites[sprite_number].x_acceleration < -4) sprites[sprite_number].x_acceleration = -4;
	}

// If the plasma ball hit anything at all, then destyoy it
if (sprite_busted == TRUE) {
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	spawn_sprite(BFG_PLASMA_BALL_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels - 8, NULL, NULL, NULL);
	play_relative_sound(ROCKET_EXPLODE_SOUND, sprite_number);
	destroy_sprite(sprite_number);
	return;
	}
}

/************************\
|** WORMINATOR MINE AI **|
\************************/
void worminator_mine_ai(int sprite_number)
{
unsigned char spawn_loop;

// See if there are solid tiles in the way of the mine and adjust the y acceleration
if (check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 1) == TRUE) sprites[sprite_number].y_acceleration = .025;
else if (check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 0) == TRUE) sprites[sprite_number].y_acceleration = .025;
else {
	sprites[sprite_number].y_acceleration += .025;
	if (sprites[sprite_number].y_acceleration > 1) sprites[sprite_number].y_acceleration = 1;

	// Apply gravity
	sprites[sprite_number].y_position_in_pixels += sprites[sprite_number].y_acceleration;
	}

// Do animations and stuff
if (sprites[sprite_number].timer <= 0) {
	if (sprites[sprite_number].frame == WORMINATOR_MINE_ARM) sprites[sprite_number].frame = WORMINATOR_MINE_REST, sprites[sprite_number].timer = 32;
	else {
		if (sprites[sprite_number].frame == WORMINATOR_MINE_REST) sprites[sprite_number].frame = WORMINATOR_MINE_FLASH;
		else sprites[sprite_number].frame = WORMINATOR_MINE_REST;
		sprites[sprite_number].timer = 32;
		}
	}
else sprites[sprite_number].timer--;

// Check to see if the mine hit an enemy and take approprate action if so
if ((sprites[sprite_number].frame != WORMINATOR_MINE_ARM && (sprite_is_touching_sprite(sprite_number, 1) >= 0 || sprite_is_touching_player(sprite_number) == TRUE)) || sprites[sprite_number].hit_points_left <= 0) {
	for (spawn_loop = 0; spawn_loop < 8; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 2, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	for (spawn_loop = 0; spawn_loop < 8; spawn_loop++) spawn_sprite(SMALL_RED_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 2, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	for (spawn_loop = 0; spawn_loop < 8; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 2, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 11, sprites[sprite_number].y_position_in_pixels - 13, NULL, NULL, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 11, sprites[sprite_number].y_position_in_pixels - 13, NULL, NULL, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 11, sprites[sprite_number].y_position_in_pixels - 13, NULL, NULL, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 11, sprites[sprite_number].y_position_in_pixels - 13, NULL, NULL, NULL);
	destroy_sprite(sprite_number);
	}

}

/****************************\
|** ENEMY PLASMA BULLET AI **|
\****************************/
void enemy_plasma_bullet_ai(int sprite_number)
{
char sprite_busted = FALSE;

// Check the lifetime timer
if (sprites[sprite_number].timer > 0) sprites[sprite_number].timer--;
else sprite_busted = TRUE;

// Move the bullet right or left
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;

// Check for a collision with the player
if (sprite_is_touching_player(sprite_number) == TRUE && player.health_bars_left != 0) {
	if (rand() % 4 == 2) hurt_player(-1);
	sprite_busted = TRUE;
	}

// See if there are solid tiles in the way of the bullet
if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + (sprites[sprite_number].width / 2), sprites[sprite_number].y_position_in_pixels, 1);

// If the bullet hit anything at all, then destroy it
if (sprite_busted == TRUE) {
	spawn_sprite(SMALL_RED_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (sprites[sprite_number].x_acceleration / 2) * -1, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	destroy_sprite(sprite_number);
	return;
	}
}

/*************************\
|** ENEMY LASER BOLT AI **|
\*************************/
void enemy_laser_bolt_ai(int sprite_number)
{
char sprite_busted = FALSE;
unsigned char spawn_loop;

// Check to see if the laser has hit the range limit
sprites[sprite_number].timer--;
if (sprites[sprite_number].timer == 0) sprite_busted = TRUE;

// Check to see if the laser hit the player
if (sprite_is_touching_player(sprite_number) == TRUE && player.health_bars_left != 0) hurt_player(-1), sprite_busted = TRUE;

// Move the laser right or left
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;

// See if there are solid tiles in the way of the laser
if (sprites[sprite_number].direction == 0) {
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels, 2);
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	}

else {
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, 2);
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	}

if (sprite_busted == TRUE) {
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
//	play_relative_sound(ROCKET_EXPLODE_SOUND, sprite_number);
	destroy_sprite(sprite_number);
	return;
	}
}

/***************************\
|** SMALL ENEMY ROCKET AI **|
\***************************/
void small_enemy_rocket_ai(int sprite_number)
{
char sprite_busted = FALSE;
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE && player.health_bars_left != 0) sprite_busted = TRUE;

// Move the rocket right or left, and up or down if the rocket is a split missle rocket
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;
sprites[sprite_number].y_position_in_pixels += sprites[sprite_number].y_acceleration;

// See if there are solid tiles in the way of the rocket and adjust the rocket's speed
if (sprites[sprite_number].direction == 0) {
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels, 2);
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	sprites[sprite_number].x_acceleration += .025;
	if (sprites[sprite_number].x_acceleration > 2) sprites[sprite_number].x_acceleration = 2;
	}

else {
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, 2);
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	sprites[sprite_number].x_acceleration -= .025;
	if (sprites[sprite_number].x_acceleration < -2) sprites[sprite_number].x_acceleration = -2;
	}

if (sprite_busted == TRUE) {
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	spawn_sprite(SMALL_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 1, sprites[sprite_number].y_position_in_pixels - 4, NULL, NULL, NULL);
	play_relative_sound(ROCKET_EXPLODE_SOUND, sprite_number);
	destroy_sprite(sprite_number);
	return;
	}
}

/***************************\
|** LARGE ENEMY ROCKET AI **|
\***************************/
void large_enemy_rocket_ai(int sprite_number)
{
char sprite_busted = FALSE;
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE && player.health_bars_left != 0) sprite_busted = TRUE;

// This is some basic animation code -- IMPROVE IT ASAP
if (sprites[sprite_number].frame == LARGE_ENEMY_ROCKET_FLY_01) sprites[sprite_number].frame = LARGE_ENEMY_ROCKET_FLY_02;
else sprites[sprite_number].frame = LARGE_ENEMY_ROCKET_FLY_01;

// Move the rocket right or left, and up or down if the rocket is a split missle rocket
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;
sprites[sprite_number].y_position_in_pixels += sprites[sprite_number].y_acceleration;

// See if there are solid tiles in the way of the rocket and adjust the rocket's speed
if (sprites[sprite_number].direction == 0) {
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels, 2);
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	sprites[sprite_number].x_acceleration += .025;
	if (sprites[sprite_number].x_acceleration > 2) sprites[sprite_number].x_acceleration = 2;
	}

else {
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, 2);
	if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2);
	sprites[sprite_number].x_acceleration -= .025;
	if (sprites[sprite_number].x_acceleration < -2) sprites[sprite_number].x_acceleration = -2;
	}

if (sprite_busted == TRUE) {
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels - 10, NULL, NULL, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels - 10, NULL, NULL, NULL);
	play_relative_sound(ROCKET_EXPLODE_SOUND, sprite_number);
	destroy_sprite(sprite_number);
	return;
	}
}

/*********************\
|** ENEMY MORTAR AI **|
\*********************/
void enemy_mortar_ai(int sprite_number)
{
char sprite_busted = FALSE;
unsigned char spawn_loop;

// Update lifespan timer
if (sprites[sprite_number].timer == 0) sprite_busted = TRUE;
else sprites[sprite_number].timer--;

// Rotate the mortar
if (sprites[sprite_number].rotate_factor == 255) sprites[sprite_number].rotate_factor = 0;
else sprites[sprite_number].rotate_factor++;

// Move the mortar
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;
sprites[sprite_number].y_position_in_pixels += sprites[sprite_number].y_acceleration;

// Check to see if the mortar hit an enemy and take appropriate action if so
if (sprite_is_touching_player(sprite_number) == TRUE) sprite_busted = TRUE;

// Check x direction
if (sprites[sprite_number].x_acceleration > 0 && check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height / 2, 2) == TRUE) sprites[sprite_number].x_acceleration = sprites[sprite_number].x_acceleration * -1;
else if (sprites[sprite_number].x_acceleration < 0 && check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height / 2, 2) == TRUE) sprites[sprite_number].x_acceleration = sprites[sprite_number].x_acceleration * -1;

// Check y direction
if (sprites[sprite_number].y_acceleration > 0 && check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width / 2, sprites[sprite_number].y_position_in_pixels + sprites[sprite_number].height, 2) == TRUE) sprites[sprite_number].y_acceleration = sprites[sprite_number].y_acceleration * -1;
else if (sprites[sprite_number].y_acceleration < 0 && check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + sprites[sprite_number].width / 2, sprites[sprite_number].y_position_in_pixels, 2) == TRUE) sprites[sprite_number].y_acceleration = sprites[sprite_number].y_acceleration * -1;

// Apply gravity to the mortar
sprites[sprite_number].y_acceleration += .025;

// If the mortar hit anything damageable, then destyoy it
if (sprite_busted == TRUE) {
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 10, sprites[sprite_number].y_position_in_pixels - 10, NULL, NULL, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 10, sprites[sprite_number].y_position_in_pixels - 10, NULL, NULL, NULL);
	spawn_sprite(MEDIUM_EXPLOSION_SPRITE, sprites[sprite_number].x_position_in_pixels - 10, sprites[sprite_number].y_position_in_pixels - 10, NULL, NULL, NULL);
	play_relative_sound(ROCKET_EXPLODE_SOUND, sprite_number);
	destroy_sprite(sprite_number);
	return;
	}
}

/********************\
|** ENEMY TOXIN AI **|
\********************/
void enemy_toxin_ai(int sprite_number)
{
char sprite_busted = FALSE;

// Move the toxin right or left
sprites[sprite_number].x_position_in_pixels += sprites[sprite_number].x_acceleration;

// Check for a collision with the player
if (sprite_is_touching_player(sprite_number) == TRUE && player.health_bars_left != 0) {
	hurt_player(-2);
	sprite_busted = TRUE;
	}

// See if there are solid tiles in the way of the bullet
if (sprite_busted == FALSE) sprite_busted = check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + (sprites[sprite_number].height / 2), 1);
else check_point_collisions_grid(sprite_number, sprites[sprite_number].x_position_in_pixels + (sprites[sprite_number].width), sprites[sprite_number].y_position_in_pixels + (sprites[sprite_number].height / 2), 1);

// If the toxin hit anything at all, then destroy it
if (sprite_busted == TRUE) {
	spawn_sprite(SMALL_RED_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels, (sprites[sprite_number].x_acceleration / 2) * -1, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	destroy_sprite(sprite_number);
	return;
	}
}